/*!
 * Nutrient Web SDK 1.12.0 (https://www.nutrient.io/sdk/web)
 *
 * Copyright (c) 2016-2026 PSPDFKit GmbH. All rights reserved.
 *
 * THIS SOURCE CODE AND ANY ACCOMPANYING DOCUMENTATION ARE PROTECTED BY INTERNATIONAL COPYRIGHT LAW
 * AND MAY NOT BE RESOLD OR REDISTRIBUTED. USAGE IS BOUND TO THE PSPDFKIT LICENSE AGREEMENT.
 * UNAUTHORIZED REPRODUCTION OR DISTRIBUTION IS SUBJECT TO CIVIL AND CRIMINAL PENALTIES.
 * This notice may not be removed from this file.
 *
 * PSPDFKit uses several open source third-party components: https://www.nutrient.io/legal/acknowledgements/web-acknowledgements/
 */
"use strict";(globalThis.webpackChunkNutrientViewer=globalThis.webpackChunkNutrientViewer||[]).push([[362],{31328:(e,t,n)=>{n.r(t),n.d(t,{corePool:()=>l.mG,customFontsPromiseRef:()=>F,default:()=>v,loadModule:()=>P,normalizeCoreOptions:()=>l.DO,validateStandaloneConfiguration:()=>l.mn});var s=n(57191),i=n(66080),a=n(64836),o=n(70274),r=n(86223),c=n(81759),l=n(5232),u=n(33846),d=n(63050),m=n(54910),h=n(92079),f=n(98888),p=n(70934),y=n(10587);async function g(e,t,n,s,i){let a;if(i)a=i,s?.();else{const t={credentials:"same-origin"};if(n&&Object.keys(n).length>0){const e=new Headers;Object.entries(n).forEach(t=>{let[n,s]=t;e.append(n,s)}),t.headers=e}a=await fetch(e,t).finally(()=>{s?.()})}const o=await a.arrayBuffer();return{isFullyAvailable:!0,fullDocument:o,contentType:a.headers?.get("Content-Type")||await(0,y.oj)(o,t)}}async function w(e,t,n,s,o,r){if(e instanceof ArrayBuffer){const n=await(0,y.oj)(e,t);return r?.(n),{isFullyAvailable:!0,fullDocument:e,contentType:n}}(0,i.V1)("string"==typeof e,"Document is not a string");let c=!1;const{linearizedDocument:l,serverSupportsRangeRequests:u,fallbackResponse:d}=await(async()=>{if(n&&function(e){if(e.startsWith("/"))return!0;try{const t=new URL(e);return"http:"===t.protocol||"https:"===t.protocol}catch(e){return!1}}(e)){const n=await t.openLinearizedDocument(a.EA);(0,i.V1)(n,"Linearized document is not available"),n.contentType&&r&&r(n.contentType);const o=await n.initialize(e,s);return o.supportsRanges?{linearizedDocument:n,serverSupportsRangeRequests:!0,fallbackResponse:void 0}:{linearizedDocument:null,serverSupportsRangeRequests:!1,fallbackResponse:o.fullResponse}}return{linearizedDocument:null,serverSupportsRangeRequests:!1,fallbackResponse:void 0}})();try{if(!u)return c=!0,g(e,t,s,o,d);(0,i.V1)(l,"Linearized document is not available"),l.startDownload();if(!await l.waitUntilIsLinearizedIsKnown())return l.destroy(),c=!0,g(e,t,s,o);o?.();const n=await l.waitUntilDocumentInfoAvailable();return n?(o?.(),{isFullyAvailable:!1,documentResponse:n,contentType:"application/pdf"}):(l.destroy(),c=!0,g(e,t,s,o))}catch(n){if(l?.destroy(),c)throw n;return g(e,t,s,o)}}var b=n(48478),D=n(92726);let _;class v extends l.Ay{constructor(e){const t=e.baseUrl||(0,c.$_)(window.document),n=e.baseCoreUrl||t,s=e.baseProcessorEngineUrl||t,a={...e,baseUrl:t,baseCoreUrl:n,baseProcessorEngineUrl:s};if("string"!=typeof a.baseUrl)throw new i.uE("`baseUrl` is mandatory and must be a valid URL, e.g. `https://example.com/`");if("string"!=typeof a.document&&!(a.document instanceof ArrayBuffer))throw new i.uE("document must be either an URL to a supported document type (PDF and images), e.g. `https://example.com/document.pdf`, or an `ArrayBuffer`");if(_&&_!==a.licenseKey)throw new i.uE("Trying to re-use instance with a different licenseKey.\nUnfortunately we only allow one licenseKey per instance.\nPlease contact support for further assistance.");if("string"==typeof a.licenseKey&&a.licenseKey.startsWith("TRIAL-"))throw new i.uE("You're using the npm key instead of the license key. This key is used to download the Nutrient Web SDK package via the node package manager.\n\nLeave out the license key to activate as a trial.");super(a),this.destroyed=!1,this.activeConfiguration=e}async load(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const t=()=>{try{let e=(0,f.jU)();e||(e=(0,f.NY)({baseUrl:this._state.baseProcessorEngineUrl,mainThreadOrigin:this._state.appName||(0,r.D5)()||window.location.origin,licenseKey:this._state.licenseKey||void 0,customFonts:this._state.customFonts||void 0,dynamicFonts:this._state.dynamicFonts||void 0,fontSubstitutions:this._state.fontSubstitutions,processorEngine:this._state.processorEngine}),(0,f.Pm)(e))}catch(e){console.error("Error initializing GdPicture client:",e)}};let n=.2;e.progressCallback&&e.progressCallback("loading",n),this._isPDFJavaScriptEnabled=e.isPDFJavaScriptEnabled,"string"==typeof this._state.document&&(0,y.XC)(this._state.baseUrl,this._state.document,this._state.productId),this._state.document instanceof ArrayBuffer&&(0,y.uA)(await(0,y.oj)(this._state.document))&&t();const a=await P(this.client,this._state).finally(()=>{n+=.3,e.progressCallback&&e.progressCallback("loading",n)}),c=this.client.workerSpawner;(0,i.V1)(c,"WorkerSpawner is null");const l=c.getWorker();(0,i.V1)(l,"Worker is null");const u=o.LV(l);this.corePDFDocument=new D.N({corePDFAccess:u,canvasRendering:this._state.canvasRendering},{type:"alreadyLoadedDocument"});const p=w(this._state.document,this.corePDFDocument,this._state.allowLinearizedLoading,this._state.httpHeaders||void 0,()=>{n+=.3,e.progressCallback&&e.progressCallback("loading",n)},e=>{(0,y.uA)(e)&&t()});(0,i.V1)(a);const{features:g,signatureFeatureAvailability:b,capabilities:v,licenseData:F}=a;if(this._state.productId===h.v.SharePoint&&"string"==typeof this._state.document&&Array.isArray(a.afu)){const e=new URL(this._state.document,this._state.baseUrl);if(!a.afu.some(t=>e.hostname.match(t)))throw new i.uE(`The document origin ${e.hostname} is not authorized.`)}const A=b===d.g.ELECTRONIC_SIGNATURES&&(0,m.UX)(g)&&this._state.forceLegacySignaturesFeature?d.g.LEGACY_SIGNATURES:b;this._state=this._state.set("features",(0,s.B8)(g)).set("signatureFeatureAvailability",A),_=this._state.licenseKey;const E=await p;let C=null;if(E.isFullyAvailable){let t=E.fullDocument.slice(0),n=null;if((0,y.C5)(E.contentType)||!v.includes("GdPictureWASM"))try{this.destroyed?(t=null,C=await new Promise(()=>{})):(C=await this.client.openDocument(E.fullDocument,{password:e.password,initialPageIndex:"number"==typeof e.initialPageIndex?e.initialPageIndex:0,formsConfiguration:this._formsConfiguration}),t=null)}catch(e){"INVALID_PASSWORD"===e.message?this._state.document instanceof ArrayBuffer&&(this._state=this._state.set("document",e.callArgs[0])):"IMAGE_DOCUMENTS_NOT_LICENSED"===e.message?e.message="The image documents feature is not enabled for your license key. Please contact support or sales to purchase the UI module for your product.":v.includes("GdPictureWASM")||(e.message="File not in PDF format or corrupted."),n=e}if(v.includes("GdPictureWASM")&&(n instanceof i.uE&&n.message.includes("File not in PDF format or corrupted.")||!(0,y.C5)(E.contentType))){(0,i.V1)(t);let s,a=(0,f.jU)();try{a||(a=(0,f.NY)({baseUrl:this._state.baseProcessorEngineUrl,mainThreadOrigin:this._state.appName||(0,r.D5)()||window.location.origin,licenseKey:this._state.licenseKey||void 0,customFonts:this._state.customFonts||void 0,dynamicFonts:this._state.dynamicFonts||void 0,fontSubstitutions:this._state.fontSubstitutions,processorEngine:this._state.processorEngine}),(0,f.Pm)(a)),s=await a,(0,i.V1)(s);const n=await s.toPdf({document:t,officeConversionSettings:e.officeConversionSettings,contentType:E.contentType?.split(";")[0].trim()});C=await this.client.openDocument(n,{password:e.password,initialPageIndex:"number"==typeof e.initialPageIndex?e.initialPageIndex:0,formsConfiguration:this._formsConfiguration})}catch(e){throw"INVALID_PASSWORD"===e.message&&this._state.document instanceof ArrayBuffer&&(this._state=this._state.set("document",n.callArgs[0])),"IMAGE_DOCUMENTS_NOT_LICENSED"===e.message&&(e.message="The image documents feature is not enabled for your license key. Please contact support or sales to purchase the UI module for your product."),e}finally{t=null,s?.destroy(),(0,f.Pm)(null)}}else if(n)throw n;(0,i.V1)(C),await this.afterDocumentLoaded(C)}else C=E.documentResponse;this._state=this._state.set("documentResponse",C);const I=this.mapLicenseDataToClientInfo(F);return{features:this._state.features,signatureFeatureAvailability:this._state.signatureFeatureAvailability,hasPassword:!!e.password,password:e.password,allowedTileScales:"all",evaluation:a.evaluation,linearizedLoading:!E.isFullyAvailable,documentResponse:C,clientInfo:I}}mapLicenseDataToClientInfo(e){const t="1.12.0";if(!e)return{environment:b.n.EVALUATION,productId:b.O.WEB,productVersion:t,licenseId:void 0,demoKeyId:void 0};let n=b.n.DEVELOPMENT;return"p"===e.type?n=b.n.PRODUCTION:"d"===e.type?n=b.n.DEMO:"b"===e.type?n=b.n.DEVELOPMENT:"t"===e.type&&(n=b.n.EVALUATION),{environment:n,productId:b.O.WEB,productVersion:t,licenseId:e.li,demoKeyId:"d"===e.type?e.i:void 0}}destroy(){this.destroyed=!0,super.destroy()}getCustomFontsPromise(){return F}async afterDocumentLoaded(e){if(this._isPDFJavaScriptEnabled&&(this._initialChanges=await this.client.enablePDFJavaScriptSupport()),this._XFDF&&await this.client.importXFDF(this._XFDF.source,this._XFDF.keepCurrentAnnotations,this._XFDF.ignorePageRotation,this._XFDF.richTextEnabled),this._instantJSON&&this._instantJSON.pdfId&&e.ID.permanent){const t=this._instantJSON.pdfId,n=e.ID;if(t.permanent!==n.permanent)throw new i.uE("Could not instantiate from Instant JSON: Permanent PDF ID mismatch.\nPlease use the same PDF document that was used to create this Instant JSON.\nFor more information, please visit: https://www.nutrient.io/guides/web/importing-exporting/instant-json/");if(t.changing!==n.changing)throw new i.uE("Could not instantiate from Instant JSON: Changing PDF ID mismatch.\nPlease use the same revision of this PDF document that was used to create this Instant JSON.\nFor more information, please visit: https://www.nutrient.io/guides/web/importing-exporting/instant-json/")}if(this._trustedCAsCallback)try{const e=await this._trustedCAsCallback();if(!Array.isArray(e))throw new i.uE("Certificates response must be an array");if(e.some(e=>!(e instanceof ArrayBuffer)&&"string"!=typeof e))throw new i.uE("All certificates must be passed as ArrayBuffer (DER) or string (PEM)");await this.client.loadCertificates(e.map(u.PI))}catch(e){throw new i.uE(`Could not retrieve certificates for digital signatures validation: ${e.message}.`)}}async waitUntilFullyLoaded(e){return this.corePDFDocument.linearizedDocument.waitUntilDownloaded().then(async()=>{await this.corePDFDocument.normallyOpenLinearizedDocument(this,{password:e,initialPageIndex:0,formsConfiguration:this._formsConfiguration}),await this.afterDocumentLoaded(this._state.documentResponse)})}async getDocumentBytes(){if(this._state.document instanceof ArrayBuffer)return this._state.document;if("string"==typeof this._state.document){const e=await fetch(this._state.document);if(!e.ok)throw new i.uE(`Failed to fetch document: ${e.statusText}`);return e.arrayBuffer()}throw new i.uE("Document bytes are not available")}}const F={current:void 0};async function P(e,t){F.current=F.current||(t.customFonts?(0,p.eY)(t.customFonts):void 0);const n=(0,c.f)(t.appName);return e.loadNativeModule(t.baseCoreUrl,{mainThreadOrigin:n,disableWebAssemblyStreaming:t.disableWebAssemblyStreaming,enableAutomaticLinkExtraction:t.enableAutomaticLinkExtraction,overrideMemoryLimit:t.overrideMemoryLimit,workerSpawnerFn:()=>(0,a.pj)(t.inlineWorkers)}).then(async()=>e.load(t.baseCoreUrl,t.licenseKey,{mainThreadOrigin:n,...F.current?{customFonts:await F.current}:null,dynamicFonts:t.dynamicFonts,productId:t.productId,featureFlags:(()=>{const e=[];return t.enableCoreUnifiedComments&&e.push("UnifiedComments"),t.enableCorePreservePDFAccessibility&&e.push("PreservePDFAccessibility"),e.length>0?e:void 0})()}))}}}]);