/*!
 * Nutrient Web SDK 1.10.0 (https://www.nutrient.io/sdk/web)
 *
 * Copyright (c) 2016-2025 PSPDFKit GmbH. All rights reserved.
 *
 * THIS SOURCE CODE AND ANY ACCOMPANYING DOCUMENTATION ARE PROTECTED BY INTERNATIONAL COPYRIGHT LAW
 * AND MAY NOT BE RESOLD OR REDISTRIBUTED. USAGE IS BOUND TO THE PSPDFKIT LICENSE AGREEMENT.
 * UNAUTHORIZED REPRODUCTION OR DISTRIBUTION IS SUBJECT TO CIVIL AND CRIMINAL PENALTIES.
 * This notice may not be removed from this file.
 *
 * PSPDFKit uses several open source third-party components: https://www.nutrient.io/legal/acknowledgements/web-acknowledgements/
 */
"use strict";(globalThis.webpackChunkNutrientViewer=globalThis.webpackChunkNutrientViewer||[]).push([[42],{96419:(e,t,n)=>{n.d(t,{N:()=>y});var i=n(14477),a=n(7162),s=n(85409),o=n(49568),r=n(89574),c=n(32784),l=n(9939),d=n(97881);function h(e,t,n){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,n)}function u(e,t){return e.get(p(e,t))}function m(e,t,n){return e.set(p(e,t),n),n}function p(e,t,n){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:n;throw new TypeError("Private element is not present on this object")}var g=new WeakMap,f=new WeakMap;class y{constructor(e,t){h(this,g,void 0),h(this,f,null),this.pdfLibrary=new i.T7.Qz(e),m(g,this,this.pdfLibrary.openDocument(t))}get rawDocument(){return u(g,this)}get linearizedDocument(){return(0,s.V1)(u(f,this),"Document is not linearized."),u(f,this)}async openLinearizedDocument(e){return m(f,this,await this.pdfLibrary.openLinarizedDocument(e)),m(g,this,u(f,this).document),u(f,this)}async normallyOpenLinearizedDocument(e,t){(0,s.V1)(u(f,this),"Document is not linearized."),u(f,this).destroy(),m(f,this,null),await e.client.openCreateFilePathDocument(t)}destroy(){(0,a.nl)(this.rawDocument.ctx)}renderTile(e,t,n,a,s,o,c,h){let u;o&&(u={annotations:o.annotations.filter(r.mH).map(d.eq).toJS().map((e=>({content:e}))),formFieldValues:o.formFieldValues.map(d.cA).toJS(),formFields:o.formFields.map(d.T7).toJS(),signatures:o.signatures||[],attachments:o.attachments});const m=this.rawDocument.renderer.renderTile(e,t,n,{renderForPrinting:a,renderText:s,priority:t.width===n.width&&t.height===n.height?i.MX.bx.High:i.MX.bx.Normal,queueOrder:c,loadPriority:h},u).then((e=>(0,l.vB)({buffer:e.buffer.buffer,width:n.width,height:n.height,format:e.format}).then((e=>{if(null===e)throw new Error("Image handle is null");return e}))));return{promise:m.promise,cancel:m.cancel}}renderTileRaw(e,t,n,a,s,o,c){let l,h;o&&(l={annotations:o.annotations.filter(r.mH).map(d.eq).toJS().map((e=>({content:e}))),formFieldValues:o.formFieldValues.map(d.cA).toJS(),formFields:o.formFields.map(d.T7).toJS(),signatures:o.signatures||[],attachments:o.attachments}),h="high"===c?i.MX.bx.High:"normal"===c?i.MX.bx.Normal:t.width===n.width&&t.height===n.height?i.MX.bx.High:i.MX.bx.Normal;const u=this.rawDocument.renderer.renderTile(e,t,n,{renderForPrinting:a,renderText:s,priority:h},l);return{promise:u.promise.then((e=>({buffer:e.buffer.buffer,format:e.format}))),cancel:u.cancel}}getTextLines(e){return this.rawDocument.text.getTextLines(e).then((t=>(0,c.K0)({textLines:t},e)))}getContentTree(e){return this.rawDocument.text.getContentTree(e).then((t=>{let n=[],i=0,a=0;return n=t.reduce(((t,n)=>{let{nodes:s}=n;const o=(0,c.l1)(s,e,t.length,i,a);return i+=o.reduce(((e,t)=>{let{content:n}=t;return e+(0,c.Y_)(n).size}),0),a+=o.reduce(((e,t)=>{let{content:n}=t;return e+(0,c.M3)(n).size}),0),t.concat(o)}),[]),(0,o.B8)(n)}))}compareText(e){const t={data:e.originalDocument.arrayBuffer,password:e.originalDocument.password,pageIndexes:e.originalDocument.pageIndexes},n={data:e.changedDocument.arrayBuffer,password:e.changedDocument.password,pageIndexes:e.changedDocument.pageIndexes},a={numberOfContextWords:e.comparisonOperation.options?.numberOfContextWords,wordLevel:e.comparisonOperation.options?.wordLevel};return i.MX.fu.compareText(this.rawDocument.ctx,t,n,a).then((e=>e))}}},80288:(e,t,n)=>{n.d(t,{K:()=>m});var i=n(67136),a=n(49568),s=n(85409),o=n(3985);class r{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};(0,i.A)(this,"cache",new Map),(0,i.A)(this,"hotQueue",new Set),(0,i.A)(this,"coldQueue",new Set),(0,i.A)(this,"pinnedTiles",new Set),(0,i.A)(this,"listeners",new Set),(0,i.A)(this,"currentBytes",0),(0,i.A)(this,"hits",0),(0,i.A)(this,"misses",0),(0,i.A)(this,"totalEvictedTiles",0),(0,i.A)(this,"totalEvictedBytes",0),(0,i.A)(this,"lastEvictedAt",null),(0,i.A)(this,"debugEvents",[]),(0,i.A)(this,"tileSizeCounts",new Map);const{maxMemoryMB:t,deviceType:n}=e,a="number"==typeof t?t:this.getAdaptiveCacheSize(n);this.maxBytes=1024*a*1024,this.registerDebugHandle()}getAdaptiveCacheSize(e){const t="mobile"===e||null==e&&/iPhone|iPad|iPod|Android|Mobile/i.test(navigator.userAgent),n="deviceMemory"in navigator&&"number"==typeof navigator.deviceMemory?navigator.deviceMemory:null;let i;return i=t?n&&n<=2?96:128:n&&n>=16?1024:n&&n>=8?768:512,i}generateKey(e,t,n,i){let a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:0,s=arguments.length>5?arguments[5]:void 0;const o=Math.floor(n),r=Math.floor(i),c=Math.round(1e3*t)/1e3,l=Math.round(s);return 0!==a?`${e}/mip${c}/x${o}y${r}/rot${a}/ts${l}`:`${e}/mip${c}/x${o}y${r}/ts${l}`}get(e,t,n,i){let a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:0,s=arguments.length>5?arguments[5]:void 0;const o=this.generateKey(e,t,n,i,a,s),r=this.cache.get(o);return r?(this.hits++,r.lastAccessTime=Date.now(),r.accessCount++,this.coldQueue.has(o)&&r.accessCount>2&&(this.coldQueue.delete(o),this.hotQueue.add(o)),this.recordDebugEvent("hit",this.createDebugTilePayload(r)),r):(this.misses++,this.recordDebugEvent("miss",{key:o,pageIndex:e,mip:t,tileX:n,tileY:i,tileSize:s}),null)}has(e,t,n,i){let a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:0,s=arguments.length>5?arguments[5]:void 0;const o=this.generateKey(e,t,n,i,a,s);return this.cache.has(o)}put(e,t,n,i,a){let s=arguments.length>5&&void 0!==arguments[5]?arguments[5]:"bitmap",o=arguments.length>6&&void 0!==arguments[6]?arguments[6]:0,r=arguments.length>7?arguments[7]:void 0,c=arguments.length>8?arguments[8]:void 0,l=arguments.length>9?arguments[9]:void 0;const d=this.generateKey(e,t,n,i,o,r),h=this.calculateTileMemorySize(c,l,s);this.ensureMemoryBudget(h);const u={key:d,pageIndex:e,mip:t,tileX:n,tileY:i,tileSize:r,imageData:a,format:s,width:c,height:l,byteSize:h,lastAccessTime:Date.now(),createdTime:Date.now(),accessCount:1,isPinned:!1},m=this.cache.get(d);m&&(this.currentBytes-=m.byteSize,this.hotQueue.delete(d),this.coldQueue.delete(d),this.updateTileSizeCount(m.tileSize,-1)),this.cache.set(d,u),this.hotQueue.add(d),this.currentBytes+=h,this.updateTileSizeCount(u.tileSize,1),this.emitStats(),this.recordDebugEvent("put",this.createDebugTilePayload(u))}pin(e,t,n,i){let a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:0,s=arguments.length>5?arguments[5]:void 0;const o=this.generateKey(e,t,n,i,a,s),r=this.cache.get(o);r&&(this.pinnedTiles.add(o),r.isPinned=!0,this.emitStats(),this.recordDebugEvent("pin",this.createDebugTilePayload(r)))}clearPage(e){const t=[];this.cache.forEach(((n,i)=>{n.pageIndex!==e||n.isPinned||t.push(i)})),t.forEach((e=>{this.removeTile(e)})),t.length>0&&(this.emitStats(),this.recordDebugEvent("clear_page",{pageIndex:e,details:{removed:t.length}}))}clear(){const e=[];this.cache.forEach(((t,n)=>{t.isPinned||e.push(n)})),e.forEach((e=>{this.removeTile(e)})),e.length>0&&(this.emitStats(),this.recordDebugEvent("clear_all",{details:{removed:e.length}}))}getStats(){const e=this.hits+this.misses>0?this.hits/(this.hits+this.misses):0,t={};return this.tileSizeCounts.forEach(((e,n)=>{t[n]=e})),{totalTiles:this.cache.size,totalBytes:this.currentBytes,hotTiles:this.hotQueue.size,coldTiles:this.coldQueue.size,pinnedTiles:this.pinnedTiles.size,hitRate:e,maxBytes:this.maxBytes,evictions:this.totalEvictedTiles,evictedBytes:this.totalEvictedBytes,lastEvictedAt:this.lastEvictedAt,tileSizeHistogram:t}}subscribe(e){return this.listeners.add(e),e(this.getStats()),()=>{this.listeners.delete(e)}}emitStats(){if(0===this.listeners.size)return;const e=this.getStats();this.listeners.forEach((t=>{t(e)}))}ensureMemoryBudget(e){if(this.currentBytes+e<=this.maxBytes)return;const t=this.currentBytes+e-this.maxBytes;let n=0;const i=Date.now(),a=Array.from(this.hotQueue);for(const e of a){const t=this.cache.get(e);t&&!t.isPinned&&i-t.lastAccessTime>5e3&&(this.hotQueue.delete(e),this.coldQueue.add(e))}const s=Array.from(this.coldQueue).map((e=>({key:e,tile:this.cache.get(e)}))).filter((e=>e.tile&&!e.tile.isPinned)).sort(((e,t)=>(e.tile?.lastAccessTime??0)-(t.tile?.lastAccessTime??0)));for(const{key:e,tile:i}of s){if(n>=t||!i)break;n+=i.byteSize,this.removeTile(e,!0)}if(n<t){const e=Array.from(this.hotQueue).map((e=>({key:e,tile:this.cache.get(e)}))).filter((e=>e.tile&&!e.tile.isPinned)).sort(((e,t)=>(e.tile?.lastAccessTime??0)-(t.tile?.lastAccessTime??0)));for(const{key:i,tile:a}of e){if(n>=t||!a)break;n+=a.byteSize,this.removeTile(i,!0)}}}removeTile(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];const n=this.cache.get(e);return n?(n.imageData.close(),this.cache.delete(e),this.hotQueue.delete(e),this.coldQueue.delete(e),this.pinnedTiles.delete(e),this.currentBytes-=n.byteSize,this.currentBytes=Math.max(this.currentBytes,0),this.updateTileSizeCount(n.tileSize,-1),t&&(this.totalEvictedTiles++,this.totalEvictedBytes+=n.byteSize,this.lastEvictedAt=Date.now(),this.recordDebugEvent("evict",this.createDebugTilePayload(n))),n):null}calculateTileMemorySize(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"bitmap",i=0;if("bitmap"===n)i=e*t*4;else{const a=e*t;i="jpeg"===n?Math.ceil(4*a*.15):Math.ceil(4*a*.4)}return i}getDebugTrace(){return[...this.debugEvents]}clearDebugTrace(){this.debugEvents=[]}createDebugTilePayload(e){return{key:e.key,pageIndex:e.pageIndex,mip:e.mip,tileX:e.tileX,tileY:e.tileY,tileSize:e.tileSize,bytes:e.byteSize}}recordDebugEvent(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!o.a)return;const n={timestamp:Date.now(),type:e,...t};this.debugEvents.push(n),this.debugEvents.length>2e3&&this.debugEvents.shift()}registerDebugHandle(){if(!o.a)return;if("undefined"==typeof window)return;const e={id:`tile-cache-${Date.now().toString(36)}-${Math.random().toString(36).slice(2,8)}`,getStats:()=>this.getStats(),getTrace:()=>this.getDebugTrace(),clearTrace:()=>this.clearDebugTrace()};window.__PSPDFKIT_TILE_CACHE_DEBUG__||(window.__PSPDFKIT_TILE_CACHE_DEBUG__=[]),window.__PSPDFKIT_TILE_CACHE_DEBUG__?.push(e)}updateTileSizeCount(e,t){if(!Number.isFinite(e))return;const n=(this.tileSizeCounts.get(e)||0)+t;n<=0?this.tileSizeCounts.delete(e):this.tileSizeCounts.set(e,n)}}var c=n(9627),l=n(9867),d=n(89574),h=n(28650),u=n(69371);class m{constructor(){(0,i.A)(this,"tileCache",new r({deviceType:c.LZ?"mobile":"desktop"})),(0,i.A)(this,"attachmentsCache",(0,a.T5)()),(0,i.A)(this,"cachedAPStreams",(0,a.T5)()),(0,i.A)(this,"pageAPStreamsPromises",(0,a.T5)()),(0,i.A)(this,"annotationAPStreamPromises",(0,a.T5)()),(0,i.A)(this,"_cachedRenderedAnnotations",(0,a.uY)()),(0,i.A)(this,"_objectURLs",{}),(0,i.A)(this,"_makeEnqueuedRelease",((e,t)=>{if("IMG"===e?.element?.tagName){const n=e.element.src;if(!n)return;"number"==typeof this._objectURLs[n]?this._objectURLs[n]++:this._objectURLs[n]=1;const i=e.release;e.release=()=>{this._objectURLs[n]--,this._objectURLs[n]<=0&&(i?.(),this._cachedRenderedAnnotations.has(t)&&(this._cachedRenderedAnnotations=this._cachedRenderedAnnotations.delete(t)),delete this._objectURLs[n])}}})),(0,i.A)(this,"_cacheableRenderedAnnotationSetExpire",(e=>{const t=this._cachedRenderedAnnotations.get(e);(0,s.V1)(t),t.timeout&&clearTimeout(t.timeout);const n=setTimeout((()=>{this._cachedRenderedAnnotations.has(e)&&(this._cachedRenderedAnnotations=this._cachedRenderedAnnotations.delete(e))}),3e4);this._cachedRenderedAnnotations=this._cachedRenderedAnnotations.update(e,(e=>({...e,timeout:n})))})),(0,i.A)(this,"_addCachedRenderedAnnotation",((e,t)=>{let{width:n,height:i,noZoom:a,APStreamPromise:s}=t;if(this._cachedRenderedAnnotations.size>1e3){const e=this._cachedRenderedAnnotations.keySeq().first();e&&(this._cachedRenderedAnnotations=this._cachedRenderedAnnotations.delete(e))}this._cachedRenderedAnnotations=this._cachedRenderedAnnotations.set(e,{width:n,height:i,noZoom:a,APStreamPromise:s}),this._cacheableRenderedAnnotationSetExpire(e)}))}getAnnotationFormFieldAndValue(e){const t=this.provider;(0,s.V1)(t instanceof t.constructor,"Backend can only use backend annotation provider");const n=e instanceof l.sb?t._readStateCallbacks?.getFormFieldByName(e.formFieldName):null;return{formField:n,formFieldValue:!n||n instanceof l.Vw?null:new l.E2({name:n.name,value:void 0!==n.formattedValue?n.formattedValue:"string"==typeof n.value?n.value:n.values})}}getAnnotationAvailableVariants(e){const t=this.provider;(0,s.V1)(t instanceof t.constructor,"Backend can only use backend annotation provider");return[...t._readStateCallbacks?.getAvailableVariants(e)||[],"normal"]}cachedRenderAnnotation(e,t,n,i,a,o){const r=this.provider;(0,s.V1)(r instanceof r.constructor,"Backend can only use backend annotation provider");const{formField:c,formFieldValue:l}=this.getAnnotationFormFieldAndValue(e);if(!(0,d.lG)(e,c))return this.renderAnnotation(e,l,t,n,i,a,o);const h=this.getAnnotationAvailableVariants(e);let u=!1,m=()=>{u=!0};return{promise:new Promise((async(s,r)=>{const c=t=>{const n=this.annotationAPStreamPromises.get(e.id);n&&(this.annotationAPStreamPromises=this.annotationAPStreamPromises.delete(e.id),n(t))},d=this.annotationAPStreamPromises.get(e.id);this.annotationAPStreamPromises=this.annotationAPStreamPromises.set(e.id,s),d&&d(null);try{const r=this.pageAPStreamsPromises.get(e.pageIndex);if(!r){const t=new Promise((t=>{this.annotationAPStreamPromises=this.annotationAPStreamPromises.set(e.id,t)}));return void s(await t)}await r;const d=this.cachedAPStreams.get(e.pageIndex);if(d){const t=d?d.get(e.id):null;if(t)return void c(this.getAPStream(t,a))}const{promise:p,cancel:g}=this.renderAPStream(e,l,t,n,i,h,a,o);if(u)c(null);else if(m=g,h.length>1){const t=await Promise.all(p.map((e=>e.promise)));c(t[h.indexOf(a||"normal")]),t.some(Boolean)&&this.cacheAPStream(h.reduce(((e,n,i)=>t[i]?{...e,[n]:t[i]}:e),{}),e)}else{const t=await p,n=t?this.getAPStream(t,a):null;c(n),n&&this.cacheAPStream(t,e)}}catch(e){r(e)}})),cancel:m}}cacheAPStream(e,t){let n=this.cachedAPStreams.get(t.pageIndex);n||(this.cachedAPStreams=this.cachedAPStreams.set(t.pageIndex,(0,a.T5)()),n=this.cachedAPStreams.get(t.pageIndex)),this.cachedAPStreams=this.cachedAPStreams.setIn([t.pageIndex,t.id],e)}clearAllPageAPStreams(e){const t=this.cachedAPStreams.get(e);t&&(t.forEach((e=>{this.releaseAPStream(e)})),this.cachedAPStreams=this.cachedAPStreams.delete(e)),this.pageAPStreamsPromises=this.pageAPStreamsPromises.delete(e)}clearPageAPStreams(e,t){const n=this.cachedAPStreams.get(e);n&&(n.filter(((e,n)=>t.has(n))).forEach((e=>{this.releaseAPStream(e)})),this.cachedAPStreams=this.cachedAPStreams.updateIn([e],(0,u.C$)((e=>e.filter(((e,n)=>!t.has(n)))))))}getAPStream(e,t){return e instanceof h.A?e:e?.[t||"normal"]||null}renderAPStream(e,t,n,i,a,s,o,r){if(s.length>1){const o=s.map((s=>this.renderAnnotation(e,t,n,i,a,"normal"!==s?s:void 0,r)));return{promise:o,cancel:()=>{o.forEach((e=>{e.cancel()}))}}}return this.renderAnnotation(e,t,n,i,a,o,r)}releaseAPStream(e){e instanceof h.A?e.release():Object.values(e).forEach((e=>{e.release()}))}isVisuallyIdenticalAnnotationCached(e){let{annotation:t,providedVisualAnnotationIndex:n,width:i,height:a}=e;if(!(0,d.cu)(t))return!1;const o=n||(0,d.sS)(t);if(!this._cachedRenderedAnnotations.has(o))return!1;const r=this._cachedRenderedAnnotations.get(o);return(0,s.V1)(r),(0,d.Ab)({noZoom:r.noZoom&&t.noZoom,cachedRenderedAnnotationWidth:r.width,cachedRenderedAnnotationHeight:r.height,testAnnotationWidth:i,testAnnotationHeight:a})}cachedRenderedAnnotationDiscardablePromise(e,t){let{promise:n,resolve:i,reject:a}=t;const o=this._cachedRenderedAnnotations.get(e);return(0,s.V1)(o),o.APStreamPromise.then((t=>{let n;return t&&(n=new h.A(t.element.cloneNode(!0),t.release),this._makeEnqueuedRelease(n,e),this._cacheableRenderedAnnotationSetExpire(e)),i(n),n})).catch(a),{promise:n,cancel:()=>{}}}clearRenderedAnnotationsCache(){this._cachedRenderedAnnotations.forEach((e=>{let{APStreamPromise:t,timeout:n}=e;t.then((e=>{e?.release()})),n&&clearTimeout(n)})),this._cachedRenderedAnnotations=(0,a.T5)(),this._objectURLs={}}}},20873:(e,t,n)=>{n.d(t,{mG:()=>le,Ay:()=>de,DO:()=>he,mn:()=>ue});var i=n(67136),a=n(55994),s=n(45646),o=n(85409),r=n(49568),c=n(80018),l=n(63097),d=n(37361),h=n(64337),u=n(20546),m=n(87374),p=n(68322),g=n(37094),f=n(95248),y=n(40927),b=n(9867),A=n(83145),S=n(40527),v=n(70631),w=n(11587),_=n(44439),P=n(89574),F=n(25888),k=n(9939),C=n(15168),D=n(83720),T=n(14511),I=n(41204),x=n(77270),R=n(47159),E=n(24189),V=n(96419);class B{constructor(e,t){this.identifier=e,this.callback=t}request(){return this.callback()}}var O=n(41477),L=n(5293),U=n(97881),N=n(80288),z=n(7737),j=n(82987),M=n(78625),$=n(74111),q=n(78236);class K extends((0,r.mS)({alreadyLoadedPages:(0,r.T5)(),isLoaded:!1,isDestroyed:!1})){}const H={skippedPdfObjectIds:[],skippedPdfBookmarkIds:[],annotations:[],bookmarks:[],formFieldValues:[],formFields:[],attachments:{}};class W{constructor(e,t){(0,i.A)(this,"_state",new K),(0,i.A)(this,"_formFieldsLoadedPromise",null),(0,i.A)(this,"_objectCreationPromises",(0,r.T5)()),(0,i.A)(this,"_loadBookmarksPromise",null),(0,i.A)(this,"_commentsLoadedPromise",null),(0,i.A)(this,"canCreateBackendOrphanWidgets",!1),(0,i.A)(this,"updateTabOrderTimeout",null),(0,i.A)(this,"pagesTabOrderToUpdate",(0,r.NZ)()),this._core=e,this._json=t?(0,o.$y)(t):null,this._setReadStateCallbacksPromise=new Promise((e=>{this._setReadStateCallbacksPromiseResolve=e}))}async load(){if(this._state=this._state.set("isLoaded",!0),!this._formFieldCallbacks&&await this._loadFormFieldValues(),!this._json)return this;await this._core.importInstantJSON({...H,...this._json}),(0,o.V1)(this._json);const{annotations:e,attachments:t}=this._json;if(this._isDestroyed()||!t||0===Object.entries(t).length)return this;if(e)for(let n=0;n<e.length;n++){let i=null;const a=e[n];if("imageAttachmentId"in a&&a.imageAttachmentId){const e=t?t[a.imageAttachmentId]:null;if(e)try{i=(0,M.lj)(atob(e.binary),e.contentType),(0,o.V1)(this._annotationCallbacks),this._annotationCallbacks.createAttachment(a.imageAttachmentId,i)}catch(e){(0,o.pq)(`Skipped attachment with id ${a.imageAttachmentId} from payload because an error occurred while converting the binary image to blob.`),(0,o.pq)(e)}}}return this}destroy(){this._state=this._state.set("isDestroyed",!0),this._annotationCallbacks=null,this._readStateCallbacks=null,this._bookmarkCallbacks=null,this._formFieldCallbacks=null,this._formFieldValueCallbacks=null,this._commentCallbacks=null}setReadStateCallbacks(e){this._readStateCallbacks=e,this._setReadStateCallbacksPromiseResolve?.()}setAnnotationCallbacks(e){this._annotationCallbacks=e}setBookmarkCallbacks(e){this._bookmarkCallbacks=e}setFormFieldCallbacks(e){this._formFieldCallbacks=e}setFormFieldValueCallbacks(e){this._formFieldValueCallbacks=e}setCommentCallbacks(e){this._commentCallbacks=e}createComment(e,t,n){return this._core.applyComments(t.map((e=>J(e,n))).toArray())}updateComment(e,t,n){return this._core.applyComments(t.map((e=>J(e,n))).toArray())}deleteComment(e,t,n){return this._core.applyComments(t.map((e=>J(e,n))).toArray())}async loadComments(){return this._commentsLoadedPromise||(this._commentsLoadedPromise=this._loadComments()),this._commentsLoadedPromise}async _loadComments(){this._verifyLoaded();const e=await this._core.getComments()??[],t=(0,r.B8)(e.map((e=>{let t;return t=e.pdfObjectId?e.id||e.pdfObjectId?.toString():(0,P.K1)(),(0,U.XL)(t,e)})));await Promise.all(t.map((e=>"number"==typeof e.pageIndex&&this.loadAnnotationsForPageIndex(e.pageIndex))).filter(Boolean).toArray()),this._commentCallbacks?.createComments(t,q.n),this._commentsLoadedPromise=Promise.resolve()}async updateTabOrder(e){this.pagesTabOrderToUpdate=this.pagesTabOrderToUpdate.add(e),this.updateTabOrderTimeout&&clearTimeout(this.updateTabOrderTimeout),this.updateTabOrderTimeout=setTimeout((async()=>{const e=this.pagesTabOrderToUpdate.toArray();if(this.pagesTabOrderToUpdate=(0,r.NZ)(),this._isDestroyed())return;const t=await Promise.all(e.map((e=>this._core.getTabOrder(e))));this._isDestroyed()||((0,o.V1)(this._annotationCallbacks),(0,z.vA)((()=>{e.forEach(((e,n)=>{this._annotationCallbacks?.setPageTabOrder(e,t[n])}))})))}),1e3)}async setTabOrder(e,t){return this._core.setTabOrder(e,t)}async createAnnotation(e,t){this._verifyLoaded();const n=t.find(((t,n)=>((0,o.V1)("imageAttachmentId"in e,"Annotation must have imageAttachmentId."),n===e.imageAttachmentId))),i=await this._core.createAnnotation((0,U.eq)(e),n?n.data:null);"number"!=typeof i||"number"!=typeof e.pdfObjectId||e.pdfObjectId===i||this._isDestroyed()||((0,o.V1)(this._annotationCallbacks),this._annotationCallbacks.updateAnnotations((0,r.B8)([e.set("pdfObjectId",i)]))),await this.updateTabOrder(e.pageIndex)}async updateAnnotation(e){this._verifyLoaded(),await this._core.updateAnnotation((0,U.eq)(e)),await this.updateTabOrder(e.pageIndex)}deleteAnnotation(e){return this._verifyLoaded(),this._core.deleteAnnotation((0,U.eq)(e))}createBookmark(e){return this._verifyLoaded(),this._core.createBookmark((0,j.U)(e))}updateBookmark(e){return this._verifyLoaded(),this._core.updateBookmark((0,j.U)(e))}deleteBookmark(e){return this._verifyLoaded(),this._core.deleteBookmark(e)}createFormField(e){this._verifyLoaded(),(0,o.V1)(this._readStateCallbacks);const t=this._readStateCallbacks.getFormFieldWidgets(e);return this._core.createFormField((0,U.T7)(e),t.map((e=>(0,U.eq)(e))).toArray()).then((async e=>{(0,z.vA)((()=>{e.forEach(((e,n)=>{const i=t.get(n);(0,o.V1)(i),(0,o.V1)(this._annotationCallbacks),"number"!=typeof e||"number"!=typeof i.pdfObjectId||i.pdfObjectId===e||this._isDestroyed()||this._annotationCallbacks.updateAnnotations((0,r.B8)([i.set("pdfObjectId",e)]))}))}))}))}updateFormField(e){this._verifyLoaded(),(0,o.V1)(this._readStateCallbacks);const t=this._readStateCallbacks.getFormFieldWidgets(e);return this._core.updateFormField((0,U.T7)(e),t.map((e=>(0,U.eq)(e))).toArray())}deleteFormField(e){return this._verifyLoaded(),this._core.deleteFormField((0,U.T7)(e))}loadFormFields(){return this._formFieldsLoadedPromise||(this._formFieldsLoadedPromise=this._loadFormFields()),this._formFieldsLoadedPromise}async _loadFormFields(){this._verifyLoaded();const e=await this._core.readFormJSONObjects();if(this._isDestroyed())return;let t=(0,r.B8)(),n=(0,r.B8)().withMutations((n=>{e.forEach((e=>{const{formField:i,widgets:a,value:s}=e;try{let e;e=i.pdfObjectId?i.pdfObjectId.toString():(0,P.K1)();const r=(0,U.mh)(e,i);(0,o.V1)(this._readStateCallbacks),this._readStateCallbacks.isFormFieldInState(r.name)||n.push(r.set("value",s)),a.forEach((e=>{if(e.formFieldName!==r.name)return;let n;n=e.pdfObjectId?e.id||e.pdfObjectId.toString():(0,P.K1)(),(0,o.V1)(this._readStateCallbacks),t=t.push((0,U.h8)(n,e))}))}catch(e){(0,o.pq)(`Skipped creating form field #${i.pdfObjectId} from payload because an error occurred while deserializing.`),(0,o.pq)(e)}}))}));const i={},a={};t.forEach((e=>{a[e.id]||(a[e.id]=[]),a[e.id].push(e.pdfObjectId)})),t=t.map((e=>{if(a[e.id].filter((t=>t!==e.pdfObjectId)).length>0&&e.pdfObjectId?.toString()!==e.id||this._readStateCallbacks?.isAnnotationInState(e.id)){const t=(0,P.K1)();return i[e.formFieldName]?i[e.formFieldName].push({[e.id]:t}):i[e.formFieldName]=[{[e.id]:t}],n=n.map((n=>n.name===e.formFieldName?n.update("annotationIds",(n=>n?.map((n=>n===e.id?t:n)))):n)),e.set("id",t)}return e})),Object.keys(i).forEach((e=>{const i=n.find((t=>t.name===e));(0,o.V1)(i);const a=t.filter((t=>t.formFieldName===e)).toArray().map((e=>(0,U.eq)(e)));this._core.updateFormField((0,U.T7)(i),a)})),n.size>0&&!this._isDestroyed()&&((0,o.V1)(this._formFieldCallbacks),this._formFieldCallbacks.createFormFields(n,q.n)),await this._loadFormFieldValues(),t.size>0&&!this._isDestroyed()&&((0,o.V1)(this._annotationCallbacks),this._annotationCallbacks.createAnnotations(t,(0,r.T5)(),q.n)),this._formFieldsLoadedPromise=Promise.resolve()}createFormFieldValue(e){return this._verifyLoaded(),this.setFormFieldValue(e)}setFormFieldValue(e){return this._verifyLoaded(),this._core.setFormFieldValue((0,U.cA)(e))}deleteFormFieldValue(e){return this._verifyLoaded(),this._core.deleteFormFieldValue(e.replace("form-field-value/",""))}loadAnnotationsForPageIndex(e){const t=this._state.alreadyLoadedPages.get(e);if(t)return t;const n=this._loadAnnotationsForPageIndex(e);return this._state=this._state.setIn(["alreadyLoadedPages",e],n),n}async _loadAnnotationsForPageIndex(e){this._verifyLoaded();const[t,n]=await Promise.all([this._core.annotationsForPageIndex(e),this._core.getTabOrder(e)]);if(this._isDestroyed())return;const i=[],a=[],s=t.map((e=>{let{rollover:t,down:n,...s}=e;return t&&"number"==typeof s.pdfObjectId&&i.push(s.pdfObjectId),n&&"number"==typeof s.pdfObjectId&&a.push(s.pdfObjectId),s})).filter((e=>"number"==typeof e.pageIndex));this._formFieldCallbacks&&await this.loadFormFields();const c=(0,r.B8)().withMutations((e=>{s.filter((e=>!e.id||this._readStateCallbacks&&!this._readStateCallbacks.isAnnotationInState(e.id))).forEach((t=>{t.pdfObjectId;try{let n;n=function(e){return"pspdfkit/link"===e.type&&0===e.pdfObjectId}(t)?t.id||(0,P.K1)():t.id||t.pdfObjectId.toString(),(e.some((e=>e.id===n))||this._readStateCallbacks?.isAnnotationInState(n))&&(n=(0,P.K1)(),t.id=n,this._core.updateAnnotation(t));const i=(0,U.h8)(n,t);e.push(i)}catch(e){(0,o.pq)(`Skipped creating annotation #${t.pdfObjectId} from payload because an error occurred while deserializing.`),(0,o.pq)(e)}}))}));(0,z.vA)((()=>{(0,o.V1)(this._annotationCallbacks),c.size>0&&this._annotationCallbacks.createAnnotations(c,(0,r.T5)(),q.n),this._annotationCallbacks.setPageTabOrder(e,n),i.length>0&&this._annotationCallbacks.addAnnotationVariants("rollover",i),a.length>0&&this._annotationCallbacks.addAnnotationVariants("down",a)})),this._state=this._state.setIn(["alreadyLoadedPages",e],Promise.resolve())}async _loadFormFieldValues(){this._verifyLoaded();const e=await this._core.getFormValues();if(this._isDestroyed())return;const t=(0,r.B8)().withMutations((t=>{e.forEach((e=>{try{t.push((0,U.R5)(e))}catch(t){(0,o.pq)(`Skipped creating form field value #${e.pdfObjectId} from payload because an error occurred while deserializing.`),(0,o.pq)(t)}}))}));t.size>0&&!this._isDestroyed()&&((0,o.V1)(this._formFieldValueCallbacks),this._formFieldValueCallbacks.setFormFieldValues(t))}async loadBookmarks(){this._verifyLoaded();const e=await this._core.getBookmarks();if(this._isDestroyed())return;const t=(0,r.B8)().withMutations((t=>{e.forEach((e=>{let n;n=e.id?e.id:e.pdfBookmarkId?e.pdfBookmarkId:(0,$.z)();try{t.push((0,j.r)(n,e))}catch(e){(0,o.pq)(`Skipped creating bookmark #${n} from payload because an error occurred while deserializing.`),(0,o.pq)(e)}}))}));t.size>0&&!this._isDestroyed()&&((0,o.V1)(this._bookmarkCallbacks),this._bookmarkCallbacks.createBookmarks(t,q.n))}_verifyLoaded(){(0,o.V1)(this._state.isLoaded,"StandaloneProvider not properly initialized.")}_isDestroyed(){return this._state.isDestroyed}async syncChanges(){}}function J(e,t){(0,o.V1)(e.rootId,"A new comment must have `rootId` present");const n=t.get(e.rootId);return(0,o.V1)(n,"An annotation must be present linked to the comment to create"),(0,U.wG)(e,n.pdfObjectId?.toString()===n.id?parseInt(e.rootId):e.rootId)}function G(e){return"string"==typeof e?.serialNumber&&e.body instanceof ArrayBuffer}function X(e){return e?.pkcs7 instanceof ArrayBuffer&&(!("ocspResponses"in e)||Array.isArray(e.ocspResponses)&&e.ocspResponses.every((e=>G(e))))}function Q(e){if(!e)return!1;const{signedData:t,timestampResponse:n,ocspResponses:i}=e;if(!(t instanceof ArrayBuffer))return!1;if(n&&!(n instanceof ArrayBuffer))return!1;if(i){if(!Array.isArray(i))return!1;if(!i.every((e=>G(e))))return!1}return!0}var Y=n(93994),Z=n(34247);class ee{constructor(e){this.backend=e}async signDocumentAndReload(e,t){const n=e?.signingData,i=n?.certificates;(0,o.V1)(void 0===t||"function"==typeof t,"On a Standalone deployment, when `signaturePreparationData.signingData.privateKey` is not provided, `twoStepSignatureCallbackOrSigningServiceData` must be a function or `NutrientViewer.StandaloneSigningServiceData`."),(0,o.V1)(!n?.timestamp||"string"==typeof n?.timestamp?.url,"The `url` property of `signingData.timestamp` must be a string."),(0,o.V1)(!n?.timestamp||!n?.timestamp?.password||"string"==typeof n?.timestamp?.password,"The `password` property of `signingData.timestamp` must be a string."),(0,o.V1)(!n?.timestamp||!n?.timestamp?.username||"string"==typeof n?.timestamp?.username,"The `username` property of `signingData.timestamp` must be a string."),(0,o.V1)(void 0===n?.ltv||"boolean"==typeof n?.ltv,"The `ltv` property of `signingData` must be a boolean if set."),(0,o.V1)(void 0===n?.ltv||"boolean"==typeof n?.ltv,"The `ltv` property of `signingData` must be a boolean if set."),(0,o.V1)(!n||!n.signatureType||n.signatureType===Y.D.CMS||Array.isArray(i)&&i.length>0&&i.every((e=>Boolean(e instanceof ArrayBuffer&&e.byteLength>0||"string"==typeof e&&e.length>0))),"For signatures of type `NutrientViewer.SignatureType.CAdES` an `Array` of certificates must be provided in `signaturePreparationData.signingData.certificates`.");const a={signatureType:n?.signatureType||(Array.isArray(i)&&i.length>0?Y.D.CAdES:Y.D.CMS),...i&&{certificates:i.map((e=>e instanceof ArrayBuffer?c.o4.fromUint8Array(new Uint8Array(e)):c.o4.encode(e)))},...e?.placeholderSize?{estimatedSize:e.placeholderSize}:null};try{const{hash:i,signatureFormFieldName:s,file:r,fileContents:l,dataToBeSigned:d}=await this.backend.client.prepareSign((0,U.Y6)(a),e?.signatureMetadata?(0,U.sZ)(e.signatureMetadata):null,Boolean(e?.flatten),e?.formFieldName,(0,U.qN)(e?.position),await(0,U.z8)(e?.appearance)),h=function(e){const t=e.trim(),n=t.length/2,i=new Uint8Array(n);for(let e=0;e<n;e++)i[e]=parseInt(t.substr(2*e,2),16);return i}(d);let u,m,p;if(t){try{u=await t({hash:i,fileContents:l,dataToBeSigned:h})}catch(e){throw new o.uE(`\`twoStepSignatureCallback\` threw an error: ${e}`)}if(!(u instanceof ArrayBuffer||X(u)||Q(u)))throw new o.uE(`The resolved value from \`twoStepSignatureCallback\` should be a an \`ArrayBuffer\`, \`SignatureCallbackResponsePkcs7\`, or \`SignatureCallbackResponseRaw\`, but is of type \`${typeof u}\` instead.`);p=u}else{if(!n?.privateKey)throw new o.uE("No `twoStepSignatureCallback` or `signingData.privateKey` was provided.");{const e={name:"RSASSA-PKCS1-v1_5",hash:{name:"SHA-256"},modulusLength:2048,extractable:!1,publicExponent:new Uint8Array([1,0,1])},t=await globalThis.crypto.subtle.importKey("pkcs8",function(e){const t=e.split("\n");let n="";for(let e=0;e<t.length;e++){t[e].trim().length>0&&t[e].indexOf("-BEGIN RSA PRIVATE KEY-")<0&&t[e].indexOf("-BEGIN PRIVATE KEY-")<0&&t[e].indexOf("-BEGIN RSA PUBLIC KEY-")<0&&t[e].indexOf("-BEGIN CERTIFICATE-")<0&&t[e].indexOf("-END RSA PRIVATE KEY-")<0&&t[e].indexOf("-END PRIVATE KEY-")<0&&t[e].indexOf("-END RSA PUBLIC KEY-")<0&&t[e].indexOf("-END CERTIFICATE-")<0&&(n+=t[e].trim())}return c.o4.toUint8Array(n).buffer}(n.privateKey),e,!0,["sign"]);m=await globalThis.crypto.subtle.sign(e,t,h),p=m}}let g="",f=a.certificates||[];if(p instanceof ArrayBuffer)g=c.o4.fromUint8Array(new Uint8Array(p))||"";else if(X(p)){const e=p;g=c.o4.fromUint8Array(new Uint8Array(e.pkcs7))||""}else if(Q(p)){const e=p;g=c.o4.fromUint8Array(new Uint8Array(e.signedData))||"",f=e.certificates.map((e=>e instanceof ArrayBuffer?c.o4.fromUint8Array(new Uint8Array(e)):c.o4.encode(e)))}let y=null,b=[];if(n?.ltv&&(p instanceof ArrayBuffer?b=await this.backend.getRevocationResponses(f):(X(p)||Q(p))&&((0,o.V1)(null==p.ocspResponses||Array.isArray(p.ocspResponses)&&p.ocspResponses.every((e=>G(e))),"The `ocspResponses` property of `signatureData` must be a array of `OCSPResponses`."),b=p.ocspResponses?.map((e=>({response_code:200,body:c.o4.fromUint8Array(new Uint8Array(e.body)),token:e.serialNumber})))??[],b.length||((0,o.R8)("The `TwoStepSignatureCallback` didn't return certificate revocation responses; trying to fetch them online."),b=await this.backend.getRevocationResponses(f)))),Q(p)){const e=p;(0,o.V1)(null==e.timestampResponse||e.timestampResponse instanceof ArrayBuffer,"The `timestampResponse` property of `signatureData` must be an `ArrayBuffer`."),e.timestampResponse&&(y={response_code:200,body:c.o4.fromUint8Array(new Uint8Array(e.timestampResponse)),token:"1234"})}if(!y&&n?.timestamp&&p instanceof ArrayBuffer){const e=c.o4.toUint8Array(g).buffer;y=await this.backend.timestampData(e,n.timestamp)}const A=await this.backend.client.sign(r,s,i,U.xz[a.signatureType],g,f,X(p)?"pkcs7":Q(p)?"raw":n?.signatureContainer?n.signatureContainer:null,y,b);return n?.ltv&&A.signature.certificateChainValidationStatus===Z.k.ok_but_could_not_check_revocation&&(0,o.R8)("Document signed, but couldn't add certificate revocation information so the signature may not be LTV-enabled."),await this.backend.reloadDocument(),s}catch(e){throw await this.backend.client.restoreToOriginalState(),e}}}var te=n(64966),ne=n(54139),ie=n(7199);class ae extends ee{constructor(e){super(e)}async signDocumentAndReload(e,t){t=(0,S.k)(t),(0,o.V1)(t,"`twoStepSignatureCallbackOrStandaloneSigningServiceData` must be a `NutrientViewer.StandaloneSigningServiceData` object when performing signing via a backend service.");const{jwt:n,signingToken:i}=t,a=this.resolveApiBasePath(t),s=this.resolveServerUrl(t),r=await this.getCertificates(s,n,`${a}get_certificates`,i),c=this.signatureCallbackFactory(s,n,r,e,t,`${a}sign_hash`);return await super.signDocumentAndReload({...e,signingData:{...e?.signingData,signatureType:e?.signingData?.signatureType||Y.D.CAdES,certificates:r}},c)}async getCertificates(e,t,n,i){let a;const s=`${e}${n}`;try{a=await fetch(s,{method:"POST",headers:{Authorization:`Bearer ${t}`,Accept:"application/json","Content-Type":"application/json"},credentials:"same-origin",body:JSON.stringify({signingToken:i})})}catch(e){throw new o.uE(`The signing service failed to retrieve certificates: Failed to fetch from ${s}`)}if(!a.ok)throw new o.uE(`The signing service failed to retrieve certificates: ${await a.json()}`);const r=(await a.json())?.data||{};return r.certificates.concat(r.ca_certificates).map((e=>c.o4.fromBase64(e)))}resolveApiBasePath(e){return(0,te.i)(e.jwt).api_base_path||"/api/"}resolveServerUrl(e){const t=e.serverUrl||(0,te.i)(e.jwt).server_url;return(0,o.V1)(t,"`twoStepSignatureCallbackOrStandaloneSigningServiceData.jwt` must contain claim `server_url` or the `twoStepSignatureCallbackOrStandaloneSigningServiceData.serverUrl` should be set"),t}signatureCallbackFactory(e,t,n,i,a,s){return async r=>{let l,{hash:d,dataToBeSigned:h}=r;try{l=await fetch(`${e}${s}`,{method:"POST",headers:{Authorization:`Bearer ${t}`,Accept:"application/json","Content-Type":"application/json"},credentials:"same-origin",body:JSON.stringify({dataToBeSigned:c.o4.fromUint8Array(h),hash:d,signatureType:i?.signingData?.signatureType||Y.D.CAdES,signingToken:a.signingToken,cadesLevel:i?.signingData?.padesLevel||ne.s.b_lt})})}catch(t){throw new o.uE(`The signing service failed to retrieve certificates: Failed to fetch from ${e}${s}`)}if(!l.ok)throw new o.uE(`The signing service failed to sign: ${await l.text()}`);const u=(await l.json())?.data||{};if(i?.signingData?.signatureContainer===ie.Y.pkcs7){const e={pkcs7:c.o4.toUint8Array(u.pkcs7).buffer};return u.ocspResponses&&(e.ocspResponses=u.ocspResponses.map((e=>({serialNumber:e.serialNumber,body:c.o4.toUint8Array(e.body).buffer})))),e}{const e={certificates:n,signedData:c.o4.toUint8Array(u.signedData).buffer,timestampResponse:c.o4.toUint8Array(u.timestampResponse).buffer};return u.ocspResponses&&(e.ocspResponses=u.ocspResponses.map((e=>({serialNumber:e.serialNumber,body:c.o4.toUint8Array(e.body).buffer})))),e}}}}var se=n(30026),oe=n(85553);class re extends(r.mS({baseUrl:null,baseCoreUrl:null,baseProcessorEngineUrl:null,licenseKey:null,document:null,backendPermissions:new se.A,documentResponse:null,disableWebAssemblyStreaming:!1,enableAutomaticLinkExtraction:!1,overrideMemoryLimit:null,features:(0,r.B8)(),signatureFeatureAvailability:oe.g.NONE,documentHandle:null,trustedCAsCallback:null,signaturesInfoPromise:null,customFonts:null,fontSubstitutions:null,forceLegacySignaturesFeature:!1,forceAnnotationsRender:!1,appName:null,lazyLoadedPages:null,productId:null,processorEngine:null,dynamicFonts:null,inlineWorkers:!0,allowLinearizedLoading:!1,enableCoreUnifiedComments:!1,enableCorePreservePDFAccessibility:!1,httpHeaders:null})){}let ce;ce=n(55994).Fe;const le=new a.iy(ce);class de extends N.K{constructor(e){super(),(0,i.A)(this,"type","STANDALONE"),(0,i.A)(this,"standaloneDocumentSigner",new ee(this)),(0,i.A)(this,"signingServiceDocumentSigner",new ae(this)),(0,i.A)(this,"_XFDF",null),ue(e);const{baseUrl:t,baseCoreUrl:n,baseProcessorEngineUrl:a,instantJSON:o,XFDF:r,enableAutomaticLinkExtraction:c,overrideMemoryLimit:l,trustedCAsCallback:h,electronAppName:u,appName:g,isSharePoint:f,isSalesforce:y,productId:b,processorEngine:A,dynamicFonts:S,inlineWorkers:v,formsConfiguration:w,allowLinearizedLoading:_,unifiedCommentsSupport:P,preservePDFAccessibility:F}=e;"string"==typeof r&&(this._XFDF={source:r,keepCurrentAnnotations:!0===e.XFDFKeepCurrentAnnotations,ignorePageRotation:!0===e.XFDFIgnorePageRotation,richTextEnabled:!0===e.XFDFRichTextEnabled}),o&&o.annotations&&(o.annotations=o.annotations.map((e=>(e.id=e.id?.toString(),e)))),this._instantJSON=o,this._formsConfiguration=w,"function"==typeof h&&(this._trustedCAsCallback=h);const{disableWebAssemblyStreaming:k,customFonts:C,fontSubstitutions:D}=e,{standaloneInstancesPoolSize:T}=e;void 0!==T&&(le.size=T);const I=!!e.electronicSignatures&&Boolean(e.electronicSignatures.forceLegacySignaturesFeature);let x=b||null;!f&&!y||x||(x=f?p.v.SharePoint:p.v.Salesforce),this._state=new re(he({baseUrl:t,baseCoreUrl:n,baseProcessorEngineUrl:a,licenseKey:e.licenseKey,document:e.document,disableWebAssemblyStreaming:k,enableAutomaticLinkExtraction:c,overrideMemoryLimit:l,documentHandle:"0",customFonts:C,fontSubstitutions:D,forceLegacySignaturesFeature:I,appName:g||u,productId:x,processorEngine:A||m.j.fasterProcessing,dynamicFonts:S,inlineWorkers:v,allowLinearizedLoading:_,enableCoreUnifiedComments:P,enableCorePreservePDFAccessibility:F,httpHeaders:e.httpHeaders})),this._requestQueue=new s.L(d.z3);const{object:R,checkIn:E}=le.checkOut();this.client=R,this.checkIn=E,this.corePDFDocument=new V.N({wasmClient:this.client},{type:"alreadyLoadedDocument"});const B=o?{annotations:o.annotations||[],formFields:o.formFields||[],formFieldValues:o.formFieldValues||[],skippedPdfObjectIds:o.skippedPdfObjectIds||[],skippedPdfFormFieldIds:o.skippedPdfFormFieldIds||[],attachments:o.attachments||{},bookmarks:o.bookmarks||[],skippedPdfBookmarkIds:o.skippedPdfBookmarkIds||[],comments:o.comments||void 0,skippedComments:o.skippedComments||void 0,format:o.format,...o.pdfId?{pdfId:o.pdfId}:null}:null;this.provider=new W(this.client,B)}isUsingInstantProvider(){return!1}hasClientsPresence(){return!1}async load(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this._isPDFJavaScriptEnabled=e.isPDFJavaScriptEnabled,{features:this._state.features,signatureFeatureAvailability:this._state.signatureFeatureAvailability,hasPassword:!!e.password,password:e.password,allowedTileScales:"all"}}async afterDocumentLoaded(e){}destroy(){this.corePDFDocument.destroy(),this.provider&&this.provider.destroy(),this._requestQueue&&this._requestQueue.destroy(),this.checkIn()}async documentInfo(){return this._state.documentResponse}async lazyLoadPages(){if(!this._state.lazyLoadedPages){const e=await this.client.getAllPageInfos(this._state.documentResponse.pageCount);this._state=this._state.set("lazyLoadedPages",e)}return this._state.lazyLoadedPages}getDocumentHandle(){return this._state.documentHandle}getFormJSON(){return this.client.getFormJSON()}permissions(){return Promise.resolve(this._state.backendPermissions)}textForPageIndex(e){return this.corePDFDocument.getTextLines(e)}getContentTreeForPageIndex(e){return this.corePDFDocument.getContentTree(e)}getTextFromRects(e,t){return this.client.getTextFromRects(e,t.toJS())}getAvailableFontFaces(e){return this.client.getAvailableFontFaces(e)}async getSuggestedLineHeightFactor(e){return"number"!=typeof e.pdfObjectId?1:"number"!=typeof e.pageIndex?((0,o.R8)("Annotation must have a pageIndex."),1):(e.lineHeightFactor&&(0,o.R8)(`Annotation ${e.id} already has a line height factor.`),this.client.getSuggestedLineHeightFactor(e.pdfObjectId,e.pageIndex))}async getClosestSnapPoint(e){const t=await this.client.getClosestSnapPoint(e.x,e.y);return t&&"number"==typeof t[0]&&"number"==typeof t[1]?new w.bR({x:t[0],y:t[1]}):e}configureSnapper(e){return this.client.configureSnapper(e)}renderAnnotation(e,t,n,i,a,s,o){if(0===Math.floor(i)||0===Math.floor(a))return{promise:Promise.resolve(void 0),cancel:()=>{}};const r=(0,x.yl)();let c;if((0,P.cu)(e)){if(c=(0,P.sS)(e),this.isVisuallyIdenticalAnnotationCached({annotation:e,providedVisualAnnotationIndex:c,width:i,height:a}))return this.cachedRenderedAnnotationDiscardablePromise(c,r);this._addCachedRenderedAnnotation(c,{width:i,height:a,noZoom:e.noZoom,APStreamPromise:r.promise})}const l=e.id,d=new B(l,(()=>this.client.renderAnnotation((0,U.eq)(e),n,i,a,(0,C.LG)(),s,o).then((e=>e?"string"==typeof e?(0,k.$3)(e):(0,k.vB)({buffer:e,width:i,height:a}):Promise.resolve(null))).then((t=>((0,P.cu)(e)&&this._makeEnqueuedRelease(t,c),r.resolve(t),t)))));return this._requestQueue.enqueue(d,!1)}async getMeasurementSnappingPoints(e){return this.client.getMeasurementSnappingPoints(e)}async getSecondaryMeasurementUnit(){return await this.client.getSecondaryMeasurementUnit()}async setSecondaryMeasurementUnit(e){return await this.client.setSecondaryMeasurementUnit(e)}async compareDocuments(e,t){const n={originalDocument:e.originalDocument,changedDocument:e.changedDocument,comparisonOperation:(0,f.c)(t)};return this.corePDFDocument.compareText(n).promise}async renderPageAnnotations(e,t,n){const i=this.provider,a=[],s=[],r=t.some((e=>e instanceof b.sb));r&&await i._setReadStateCallbacksPromise;const c=t.filter((e=>{const t=r?i._readStateCallbacks.getAnnotationWithFormField(e.id):null,n=t?.formField,o=(0,P.lG)(e,n);if(o&&n){a.find((e=>e.name===n.name))||(a.push((0,U.cA)((0,D.Af)(n))),s.push(n))}return o}));function l(e,t){if((0,P.uM)(e)){const n=s.find((t=>t.name===e.formFieldName)),i=t.find((t=>t.name===e.formFieldName));if(!(0,D.Ny)(n,i))return!1}return!0}const d=new Promise(((t,a)=>{const r=c.filter((e=>0!==Math.floor(e.boundingBox.width*n)&&0!==Math.floor(e.boundingBox.height*n)));this.client.renderPageAnnotations(e,r.map((e=>e.pdfObjectId)).toArray(),r.map((e=>e.boundingBox.width*n)).toArray(),r.map((e=>e.boundingBox.height*n)).toArray(),(0,C.LG)()).then((e=>{const a=s.map((e=>i._readStateCallbacks?.getFormFieldByName(e.name))).filter(Boolean),c=e.map(((e,t)=>{const i=r.get(t);return(0,o.V1)(i),l(i,a)&&i&&e?"string"==typeof e?(0,k.$3)(e):(0,k.vB)({buffer:e,width:i.boundingBox.width*n,height:i.boundingBox.height*n}):Promise.resolve(null)}));Promise.all(c).then((e=>{const a=s.map((e=>i._readStateCallbacks?.getFormFieldByName(e.name))).filter(Boolean);e.forEach(((e,t)=>{const i=r.get(t);if(i){const{formFieldValue:t}=this.getAnnotationFormFieldAndValue(i),s=this.getAnnotationAvailableVariants(i),o=this.annotationAPStreamPromises.get(i.id),r=l(i,a);if(o&&(this.annotationAPStreamPromises=this.annotationAPStreamPromises.delete(i.id),o(r?e:null)),s.length>1){const a={normal:e};e&&r&&this.cacheAPStream(a,i);const{promise:o}=this.renderAPStream(i,t,null,i.boundingBox.width*n,i.boundingBox.height*n,s);Promise.all(o.map((e=>e.promise))).then((e=>{e.some(Boolean)&&s.forEach(((t,n)=>{"normal"!==t&&e[n]&&(a[t]=e[n])}))}))}else e&&r&&this.cacheAPStream(e,i)}})),t()}))})).catch(a)}));return this.pageAPStreamsPromises=this.pageAPStreamsPromises.set(e,d),d}renderDetachedAnnotation(e,t,n,i){if(e.id)throw new o.uE(`Detached annotations should not have an \`id\`: ${e.id}`);const a=(0,x.yl)();let s;if((0,P.cu)(e)){if(s=(0,P.sS)(e),this.isVisuallyIdenticalAnnotationCached({annotation:e,providedVisualAnnotationIndex:s,width:n,height:i}))return this.cachedRenderedAnnotationDiscardablePromise(s,a);this._addCachedRenderedAnnotation(s,{width:n,height:i,noZoom:e.noZoom,APStreamPromise:a.promise})}const r=(0,l.Z0)(),c=new B(r,(()=>this.client.renderDetachedAnnotation((0,U.eq)(e),t,n,i,(0,C.LG)()).then((e=>e?(0,k.vB)({buffer:e,width:n,height:i}):Promise.resolve(null))).then((t=>((0,P.cu)(e)&&this._makeEnqueuedRelease(t,s),a.resolve(t),t))).catch((()=>{const e=this._cachedRenderedAnnotations.get(s);e&&e.timeout&&clearTimeout(e.timeout),this._cachedRenderedAnnotations.delete(s)})))),{promise:d,cancel:h}=this._requestQueue.enqueue(c,!1);return{promise:d,cancel:h}}async getAttachment(e){const[t,n]=await this.client.getAttachment(e);return new Blob([t],{type:n})}async parseXFDF(e,t,n){const{errors:i,formFieldValues:a,annotations:s}=await this.client.parseXFDF(e,t,n);return{errors:i?.map((e=>({errorMessage:e.error_message,type:e.type}))),formFieldValues:a?.reduce(((e,t)=>(e[t.fqdn]=t.values,e)),{}),annotations:(0,r.B8)(s?.map((e=>(0,U.h8)((0,P.K1)(),e)))||[])}}async search(e,t,n,i){let a=arguments.length>4&&void 0!==arguments[4]&&arguments[4],s=arguments.length>5&&void 0!==arguments[5]?arguments[5]:g.n.TEXT;const o=await this.client.search(e,t,n,i,s);return(0,R.g)(o.filter((e=>a||!e.isAnnotation)))}async searchAndRedact(e,t,n){const{totalPages:i}=n,a=await this.client.search(e,t.startPageIndex??0,t.pageRange??i,t.caseSensitive,t.searchType);return(0,r.B8)(a.filter((e=>t.searchInAnnotations||!e.isAnnotation)).map((e=>{const i=e.isAnnotation?[e.annotationRect]:e.rectsOnPage,a=(0,r.B8)(i).map((e=>((0,o.V1)(e),(0,L.a)(e))));return new A.A({...(0,P.mN)(n),...t.annotationPreset,pageIndex:e.pageIndex,rects:a,boundingBox:_.A.union(a)})})))}async exportPDF(){let{flatten:e=!1,incremental:t,saveForPrinting:n=!1,format:i="pdf",excludeAnnotations:a=!1,preserveInstantJSONChanges:s=!0,permissions:r,outputFormat:c=!1,flattenElectronicSignatures:l=e}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},d=arguments.length>1?arguments[1]:void 0;if(e&&!l)throw new o.uE("Cannot set `flattenElectronicSignatures` to `false` when `flatten` is set to `true`.");if(c&&"boolean"!=typeof c&&c.conformance&&(0,o.V1)(c.conformance&&Object.values(u.o).includes(c.conformance),"The supplied PDF/A Conformance type is not valid. Valid Conformance should be one of the following options NutrientViewer.Conformance."+Object.keys(u.o).join(", NutrientViewer.Conformance.")),void 0===t)if(this._state.features.includes(h.Y.DIGITAL_SIGNATURES)){const e=await this.getSignaturesInfo();t=!n&&Boolean("not_signed"!==e.status)}else t=!1;return this.client.exportFile(e,t,n,i,a,s,r,d).then((async e=>{let[t,n]=e;if(t.mimeType=n.mimeType,t.extension=n.extension,c){const e="boolean"!=typeof c&&c.conformance?c.conformance:u.o.PDFA_2B;let i;try{return i=await this._setupGdPictureClient(),await i.toPdf({document:t,contentType:n.mimeType,extension:n.extension,conformance:e})}finally{i?.destroy(),(0,E.Pm)(null)}}return t}))}async exportOffice(e){let t,{format:n}=e;try{const[e]=await this.client.exportFile(!1,!1,!1,"pdf",!1,!0);return t=await this._setupGdPictureClient(),await t.toOffice(e,n)}catch(e){throw new o.uE(`Exporting to ${n} failed: ${e.message}.`)}finally{t?.destroy(),(0,E.Pm)(null)}}async _setupGdPictureClient(){let e=(0,E.jU)();return e||(e=(0,E.NY)({baseUrl:this._state.baseProcessorEngineUrl,mainThreadOrigin:this._state.appName||(0,I.D5)()||window.location.origin,licenseKey:this._state.licenseKey,processorEngine:this._state.processorEngine,customFonts:this._state.customFonts,dynamicFonts:this._state.dynamicFonts,fontSubstitutions:this._state.fontSubstitutions}),(0,E.Pm)(e)),e}exportXFDF(e){return this.client.exportXFDF(e)}exportInstantJSON(e){return this.client.exportInstantJSON(e)}getPDFURL(){let{includeComments:e=!0,saveForPrinting:t,excludeAnnotations:n}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this.generatePDFObjectURL({includeComments:e,saveForPrinting:t,excludeAnnotations:n})}generatePDFObjectURL(){let e,{includeComments:t=!0,saveForPrinting:n,excludeAnnotations:i=!1}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},a=!1;return{promise:new Promise((s=>{this.exportPDF({flatten:!0,includeComments:t,saveForPrinting:n,excludeAnnotations:i}).then((t=>{if(a)return;const n=new Blob([t],{type:t.mimeType});e=window.URL.createObjectURL(n),s(e)}))})),revoke:()=>{e&&window.URL.revokeObjectURL(e),a=!0}}}async getDocumentOutline(){const e=await this.client.getDocumentOutline();return(0,r.B8)(e.map(O.r))}async setDocumentOutline(e){return this.client.setDocumentOutline(e.map(O.U).toArray())}async getPageGlyphs(e){const t=await this.client.getPageGlyphs(e);return(0,U.Fj)(t)}async onKeystrokeEvent(e){return await this.client.onKeystrokeEvent(e)}async evalFormValuesActions(e){return this.client.evalFormValuesActions(e.map(U.cA).toJS())}async evalScript(e,t,n){return this.client.evalScript(e,t,n)}async setFormJSONUpdateBatchMode(e){return this.client.setFormJSONUpdateBatchMode(e)}async getMeasurementScales(){const e=await this.client.getMeasurementScales();return e?.measurementContentFormats}async addMeasurementScale(e){return await this.client.addMeasurementScale(e)}async removeMeasurementScale(e){return await this.client.removeMeasurementScale(e)}async getAnnotationsByScale(e){return await this.client.getAnnotationsByScale(e)}async applyOperationsAndReload(e){try{const{processedOperations:t,operationsDocuments:n}=await(0,F.t)(e);await this.client.applyOperations(t,n)}catch(e){throw new o.uE(`Applying operations failed: ${e}`)}return this.provider._state=this.provider._state.set("alreadyLoadedPages",(0,r.T5)()),this.reloadDocument()}async applyRedactionsAndReload(){try{await this.client.applyRedactions()}catch(e){throw new o.uE(`Applying redactions failed: ${e}`)}return this.reloadDocument()}async reloadDocument(){try{this.provider?.destroy(),this.provider=new W(this.client,null),this._state=this._state.set("lazyLoadedPages",null);const e=await this.client.reloadDocument();return this._state=this._state.set("documentResponse",e).set("documentHandle",(parseInt(this._state.documentHandle)+1).toString()).set("signaturesInfoPromise",null),this.clearRenderedAnnotationsCache(),{features:this._state.features,signatureFeatureAvailability:this._state.signatureFeatureAvailability,hasPassword:!1,password:void 0,allowedTileScales:"all"}}catch(e){throw new o.uE(`Reloading failed: ${e}`)}}async getEmbeddedFiles(){const e=await this.client.getEmbeddedFilesList();return(0,r.B8)(e.map((e=>{let{id:t,...n}=e;return(0,y.r)(t,n,!0)})))}async exportPDFWithOperations(e){try{const{processedOperations:t,operationsDocuments:n}=await(0,F.t)(e);return this.client.exportPDFWithOperations(t,n)}catch(e){throw new o.uE(`Exporting PDF with operations failed: ${e}`)}}async setSignaturesLTV(e){try{const t=(e??[]).map((e=>e instanceof ArrayBuffer?c.o4.fromUint8Array(new Uint8Array(e)):c.o4.encode(e))),n=await this.getRevocationResponses(t),i=await this.client.setSignaturesLTV(n).then((e=>(0,U.N5)(e)));if(i.signatures?.find((e=>e.certificateChainValidationStatus===Z.k.ok_but_could_not_check_revocation)))throw"Could not set LTV for all signatures. Check that the OCSP response is valid.";return this._state=this._state.set("signaturesInfoPromise",null),this.getSignaturesInfo()}catch(e){throw new o.uE(`Setting signatures LTV failed: ${e}`)}}getSignaturesInfo(){try{if(this._state.signaturesInfoPromise)return this._state.signaturesInfoPromise;const e=this.client.getSignaturesInfo().then((e=>(0,U.N5)(e)));return this._state=this._state.set("signaturesInfoPromise",e),e}catch(e){throw new o.uE(`Getting document signatures info: ${e}`)}}async refreshSignaturesInfo(){this._state=this._state.set("signaturesInfoPromise",null)}async loadCertificates(e){return this.client.loadCertificates(e)}async getRevocationResponses(e){const t=await this.client.getRevocationRequests(e);return await Promise.all(t.map((async e=>{let{method:t,url:n,content_type:i,request_data:a,token:s}=e;try{const e=await fetch(n,{method:t,headers:{"Content-Type":i??"application/ocsp-request"},body:c.o4.toUint8Array(a).buffer}),o=await e.arrayBuffer();return{response_code:e.status,body:c.o4.fromUint8Array(new Uint8Array(o)),token:s}}catch(e){return{response_code:0,body:"",token:s,error_message:e.message}}})))}async signDocumentAndReload(e,t){(0,o.V1)(void 0===t||"function"==typeof t||(0,S.k)(t),"On a Standalone deployment, `twoStepSignatureCallbackOrSigningServiceData` must be a function or `NutrientViewer.StandaloneSigningServiceData` if provided.");const n=(0,S.k)(t);return n?this.signingServiceDocumentSigner.signDocumentAndReload(e,n):this.standaloneDocumentSigner.signDocumentAndReload(e,t)}cancelRequests(){this._requestQueue.cancelAll()}async syncChanges(){}getDefaultGroup(){}isCollaborationPermissionsEnabled(){return!1}async clearAPStreamCache(){return this.client.clearAPStreamCache()}async setComparisonDocument(e,t){return this.client.setComparisonDocument(e,t)}async openComparisonDocument(e){return this._state=this._state.set("forceAnnotationsRender",!1),await this.client.closeDocument(),this._state=this._state.set("forceAnnotationsRender",!0),await this.client.openComparisonDocument(e)||this._state.documentResponse}async documentCompareAndOpen(e){return this.client.documentCompareAndOpen(e)}async persistOpenDocument(e){return this.client.persistOpenDocument(e)}async cleanupDocumentComparison(){return this.client.cleanupDocumentComparison()}async runPDFFormattingScripts(e,t){const n=[...new Set(e)];return this.client.runPDFFormattingScripts(n,t)}async runPDFFormattingScriptsFromWidgets(e,t,n){let i=[];if(this._isPDFJavaScriptEnabled){const{withAPStream:a,withoutAPStream:s}=e.reduce(((e,i)=>{if(i instanceof b.sb){const a=t?.get(i.formFieldName);if(a instanceof b.Vw)return e;n?.(i)?e.withAPStream.push(i.formFieldName):e.withoutAPStream.push(i.formFieldName)}return e}),{withAPStream:[],withoutAPStream:[]});let o=[];if(a.length&&!s.length)o=await this.runPDFFormattingScripts(a,!0);else if(!a.length&&s.length)o=await this.runPDFFormattingScripts(s,!1);else if(a.length&&s.length){const[e,t]=await Promise.all([this.runPDFFormattingScripts(a,!0),this.runPDFFormattingScripts(s,!1)]);o=e.concat(t)}i=(0,D.A5)(this._initialChanges,o)}return i}setFontSubstitutions(e){return this.client.setFontSubstitutions(e)}async contentEditorReload(){return(0,o.V1)(this.provider instanceof W,"Standalone can only use standalone annotation provider"),this.provider._state=this.provider._state.set("alreadyLoadedPages",(0,r.T5)()),this.reloadDocument()}getOCGs(){return this.client.getOCGs()}getOCGVisibilityState(){return this.client.getOCGVisibilityState()}setOCGVisibilityState(e){return this.client.setOCGVisibilityState(e)}updateButtonIcon(e,t,n){return this.client.updateButtonIcon((0,U.eq)(e),t,n)}async timestampData(e,t){const{url:n,username:i="",password:a=""}=t,s=c.o4.fromUint8Array(new Uint8Array(e));try{const e=await this.client.getTimestampRequest(s,{url:n,username:i,password:a}),t={method:e.method,headers:{"Content-Type":e.contentType||"application/timestamp-query"},body:c.o4.toUint8Array(e.requestData).buffer};(e.username||e.password)&&(t.headers.Authorization=`Basic ${btoa(`${e.username}:${e.password}`)}`);try{const n=await fetch(e.url,t),i=await n.arrayBuffer();return{response_code:n.status,body:c.o4.fromUint8Array(new Uint8Array(i)),token:e.token}}catch(t){return{response_code:400,body:"",token:e.token,error_message:t.message}}}catch(e){return{response_code:500,body:"",token:"",error_message:e.message}}}async waitUntilFullyLoaded(e){}}function he(e){return{baseUrl:e.baseUrl,baseCoreUrl:e.baseCoreUrl,baseProcessorEngineUrl:e.baseProcessorEngineUrl,licenseKey:e.licenseKey,document:e.document,disableWebAssemblyStreaming:!!e.disableWebAssemblyStreaming,enableAutomaticLinkExtraction:!!e.enableAutomaticLinkExtraction,overrideMemoryLimit:"number"==typeof e.overrideMemoryLimit?e.overrideMemoryLimit:null,documentHandle:"number"==typeof e.documentHandle?e.documentHandle:"0",trustedCAsCallback:"function"==typeof e.trustedCAsCallback?e.trustedCAsCallback:null,customFonts:Array.isArray(e.customFonts)?e.customFonts.filter((e=>e instanceof v.A)):null,forceLegacySignaturesFeature:Boolean(e.forceLegacySignaturesFeature),appName:"string"==typeof e.appName?e.appName:null,productId:e.productId,processorEngine:e.processorEngine,dynamicFonts:e.dynamicFonts,fontSubstitutions:e.fontSubstitutions,inlineWorkers:e.inlineWorkers,allowLinearizedLoading:e.allowLinearizedLoading,enableCoreUnifiedComments:e.enableCoreUnifiedComments,enableCorePreservePDFAccessibility:e.enableCorePreservePDFAccessibility,httpHeaders:e.httpHeaders||null}}function ue(e){const{licenseKey:t,instantJSON:n,XFDF:i,disableWebAssemblyStreaming:a,disableIndexedDBCaching:s,enableAutomaticLinkExtraction:r,overrideMemoryLimit:c,standaloneInstancesPoolSize:l,trustedCAsCallback:d,baseUrl:h,baseCoreUrl:u,baseProcessorEngineUrl:m,customFonts:p,isSharePoint:g,isSalesforce:f,dynamicFonts:y,inlineWorkers:b,formsConfiguration:A,httpHeaders:S}=e;if((0,o.V1)("string"==typeof h,"`baseUrl` is mandatory and must be a valid URL, e.g. `https://example.com/"),(0,T.f4)(h),(0,o.V1)(!u||"string"==typeof u,"`baseCoreUrl` must be a valid URL if set, e.g. `https://example.com/"),u&&(0,T.Qo)(u),(0,o.V1)(!m||"string"==typeof m,"`baseProcessorEngineUrl` must be a valid URL if set, e.g. `https://example.com/"),m&&(0,T.hc)(m),(0,o.V1)(null==t||"string"==typeof t,"licenseKey must be a string value if provided. Please obtain yours from https://my.nutrient.io/."),"string"==typeof t&&(0,o.V1)(!t.startsWith("TRIAL-"),"You're using the npm key instead of the license key. This key is used to download the Nutrient Web SDK package via the node package manager.\n\nLeave out the license key to activate as a trial."),(0,o.V1)(void 0===i||"string"==typeof i,"XFDF must be a string"),n&&((0,o.yj)(n),(0,o.V1)(void 0===i,"Cannot import from both instantJSON and XFDF")),(0,o.V1)(void 0===a||"boolean"==typeof a,"disableWebAssemblyStreaming must be a boolean"),(0,o.V1)(void 0===r||"boolean"==typeof r,"enableAutomaticLinkExtraction must be a boolean"),(0,o.V1)(void 0===c||"number"==typeof c,"overrideMemoryLimit must be a number"),(0,o.V1)(void 0===l||"number"==typeof l&&l>=0,"standaloneInstancesPoolSize must be a non-negative number"),(0,o.V1)(void 0===d||"function"==typeof d,"trustedCAsCallback must be a function"),(0,o.V1)(void 0===p||Array.isArray(p)&&p.every((e=>e instanceof v.A)),"customFonts must be an array of NutrientViewer.Font instances"),(0,o.V1)(void 0===p||p.every((e=>e.callback)),"All NutrientViewer.Font instances specified on customFonts must have its callback property defined"),void 0!==s&&(0,o.t6)("disableIndexedDbCaching has been deprecated and it no longer has effect. It will be removed in a later version.\nBrowsers dropped IndexedDB serialization of Wasm modules in favor of regular HTTP caching."),(g||f)&&(0,o.t6)("isSharePoint and isSalesforce configuration properties are deprecated and will be removed in the next major release. Please use the new Configuration#productId property instead. For more information, please check the migration guide."),(0,o.V1)(!(g&&f),"You cannot enable both SharePoint and Salesforce integrations at the same time. Please set either isSharePoint or isSalesforce to true, but not both."),"string"==typeof y)try{new URL(y)}catch(e){throw new o.uE("dynamicFonts must be a valid URL to a JSON file containing the data for fonts to be dynamically loaded.")}if((0,o.V1)(void 0===b||"boolean"==typeof b,"inlineWorkers must be a boolean"),A&&(0,o.V1)(void 0===A.export?.disableComboBoxArrow||"boolean"==typeof A.export?.disableComboBoxArrow,"formsConfiguration.export.disableComboBoxArrow must be a boolean"),void 0!==S){(0,o.V1)(null!==S&&"object"==typeof S&&!Array.isArray(S),'httpHeaders must be an object with string key-value pairs, e.g. { "Authorization": "Bearer token" }'),Object.entries(S).forEach((e=>{let[t,n]=e;(0,o.V1)("string"==typeof t&&t.length>0,"httpHeaders keys must be non-empty strings representing valid HTTP header names"),(0,o.V1)("string"==typeof n,`httpHeaders value for key "${t}" must be a string. Received: ${typeof n}`)}));const e=Object.keys(S).map((e=>e.toLowerCase()));["accept-charset","accept-encoding","access-control-request-headers","access-control-request-method","connection","content-length","cookie","date","dnt","expect","host","keep-alive","origin","permissions-policy","referer","te","trailer","transfer-encoding","upgrade","via"].forEach((t=>{(0,o.V1)(!e.includes(t),`httpHeaders cannot include the "${t}" header as it is controlled by the browser. For more information, see https://developer.mozilla.org/en-US/docs/Glossary/Forbidden_request_header`)}));const t=["proxy-","sec-"];e.forEach((e=>{t.forEach((t=>{(0,o.V1)(!e.startsWith(t),`httpHeaders cannot include headers starting with "${t}" (found: "${e}") as they are controlled by the browser. For more information, see https://developer.mozilla.org/en-US/docs/Glossary/Forbidden_request_header`)}))})),e.includes("range")&&console.warn('The "Range" header in httpHeaders will be overridden during progressive loading (allowLinearizedLoading: true) to manage document chunks. Your custom Range header will only be used for non-linearized document loading.')}}},40927:(e,t,n)=>{n.d(t,{r:()=>o});var i=n(49568);class a extends(i.mS({id:"",attachmentId:"",description:null,fileName:null,fileSize:null,updatedAt:null})){}var s=n(46952);function o(e,t){return function(e,t){return t}(0,arguments.length>2&&void 0!==arguments[2]&&arguments[2])?new a({id:(0,s.A)(),description:t.fileDescription,attachmentId:e,fileName:t.fileName||null,fileSize:t.fileSize||null,updatedAt:t.modificationDate?new Date(t.modificationDate):null}):new a({id:e,description:t.description,attachmentId:t.fileAttachmentId,fileName:t.fileName||null,fileSize:t.fileSize||null,updatedAt:new Date(t.updatedAt)||null})}},41477:(e,t,n)=>{n.d(t,{U:()=>c,r:()=>l});var i=n(85409),a=n(49568),s=n(6085),o=n(16792),r=n(9867);function c(e){return{type:"pspdfkit/outline-element",children:e.children&&e.children.map((e=>c(e))).toJS(),title:e.title,color:e.color&&(0,o.J)(e.color),isBold:e.isBold,isItalic:e.isItalic,isExpanded:e.isExpanded,action:e.action&&(0,s.Ix)(e.action)}}function l(e){let t,n;(0,i.V1)("pspdfkit/outline-element"===e.type,"invalid outline element type."),(0,i.V1)(null==e.children||Array.isArray(e.children),"children must be an Array<OutlineElement>."),(0,i.V1)("string"==typeof e.title,"title must be a string."),(0,i.V1)(null==e.isBold||"boolean"==typeof e.isBold,"isBold must be a boolean."),(0,i.V1)(null==e.isItalic||"boolean"==typeof e.isItalic,"isItalic must be a boolean."),(0,i.V1)(null==e.isExpanded||"boolean"==typeof e.isExpanded,"isExpanded must be a boolean.");try{t=e.action&&(0,s._8)(e.action)}catch(t){(0,i.R8)(`PDF Action not supported ${JSON.stringify(e.action)})`)}try{n=e.color&&(0,o.p)(e.color)}catch(t){(0,i.R8)(`Invalid color:\n\n${e.color}`)}const c={title:e.title,color:n,isBold:!0===e.isBold,isItalic:!0===e.isItalic,isExpanded:!0===e.isExpanded,action:t,children:e.children&&e.children.length>0?(0,a.B8)(e.children.map(l)):(0,a.B8)()};return new r.LC(c)}},25888:(e,t,n)=>{n.d(t,{g:()=>a,t:()=>s});var i=n(85409);function a(e,t,n,i,a,s){let o;return e.has(n)?o=e.get(n):(o=a.toString(),t[o]=n,e.set(n,o)),{...i,[s]:o}}async function s(e){const t=new WeakMap,n={};return{processedOperations:await Promise.all(e.map((async(e,s)=>{if("importDocument"===e.type){const{document:o}=e;return(0,i.V1)(o instanceof File||o instanceof Blob,"Wrong `importDocument` operation `document` value: it must be a File or a Blob"),a(t,n,o,e,s,"document")}if("applyInstantJson"===e.type){const o=e.instantJson;(0,i.V1)("object"==typeof o&&null!==o,"Wrong `applyInstantJson` operation `instantJson` value: it must be an object");const r=JSON.stringify(o),c=new Blob([r],{type:"application/json"});return a(t,n,c,e,s,"dataFilePath")}if("applyXfdf"===e.type){const o=e.xfdf;(0,i.V1)("string"==typeof o,"Wrong `applyXfdf` operation `xfdf` value: it must be a string");const r=new Blob([o],{type:"application/vnd.adobe.xfdf"});return a(t,n,r,e,s,"dataFilePath")}return e}))),operationsDocuments:n}}},47159:(e,t,n)=>{n.d(t,{g:()=>r});var i=n(49568),a=n(85409),s=n(5293),o=n(3220);function r(e){return(0,a.V1)(Array.isArray(e),"Wrong `json` field"),(0,i.B8)(e.map((e=>((0,a.V1)("number"==typeof e.pageIndex,"Wrong `pageIndex` field"),(0,a.V1)("string"==typeof e.previewText,"Wrong `previewText` field"),(0,a.V1)(Array.isArray(e.rangeInPreview),"Wrong `rangeInPreview` field"),(0,a.V1)(Array.isArray(e.rectsOnPage),"Wrong `rectsOnPage` field"),new o.A({pageIndex:e.pageIndex,previewText:e.previewText,locationInPreview:e.rangeInPreview[0],lengthInPreview:e.rangeInPreview[1],rectsOnPage:(0,i.B8)(e.rectsOnPage).map((e=>(0,s.a)(e))),isAnnotation:!!e.isAnnotation,annotationRect:e.annotationRect?(0,s.a)(e.annotationRect):null})))).filter(Boolean))}}}]);